
/*=================================================================*/
/*============== WAVE 3===========*/
/*=================================================================*/

use "../Dataset/ABIII_English.dta", clear

gen wave=3
gen weight=wt
rename country cty
gen country = cty
gen urban = q13==1
recode v13 (2=0) (3/.=.)
replace urban=v13 if country==15
gen female = sex==2
recode q603 (0=.) (1/3=1) (4=0) (5/.=.), gen(lottery)
*recode q6052 (1/2=1) (3/4=0) (5/.=.), gen(islamiclaw) because there's non-Muslim
*recode q605a (1/2=1) (3/4=0) (5/.=.), gen(religiousparty) unavailable in Wave2
recode q514 (1/2=1) (3/4=0) (5/.=.), gen(gradualreform)
recode q609 (0=.) (2/3=0) (4/.=.), gen(religious)

*democracy attitudes
recode q512 (0/5=0) (6/10=1) (11/.=.)
recode q5161 (1/2=0) (3/4=1) (5/.=.)
recode q5162 (1/2=0) (3/4=1) (5/.=.)
recode q5163 (1/2=0) (3/4=1) (5/.=.)
recode q5164 (1/2=1) (3/4=0) (5/.=.)
recode q5167 (1/2=0) (3/4=1) (5/.=.)
recode q5171 (1/2=1) (3/4=0) (5/.=.)
recode q5172 (1/2=0) (3/4=1) (5/.=.)
recode q6071 (1/2=0) (3/4=1) (5/.=.)

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep country weight wave urban female lottery gradualreform religious ///
	 q512 q5161 q5162 q5163 q5164 q5167 q5171 q5172 q6071

save "wave3.dta"


/*=================================================================*/
/*============== WAVE 2===========*/
/*=================================================================*/

use "../Dataset/ABII_English.dta", clear

gen wave=2
gen weight=wt
rename country cty
gen country = cty
gen urban = q13==1
recode v13 (2=0) (3/.=.)
replace urban=v13 if country==15
gen female = q1002==2
recode q603 (0=.) (1/3=1) (4=0) (5/.=.), gen(lottery)
*recode q6052 (1/2=1) (3/4=0) (5/.=.), gen(islamiclaw) because there's non-Muslim
*recode sa6052 (1/2=1) (3/4=0) (5/.=.)
*replace islamiclaw = sa6052 if country==17
recode q514 (1/2=1) (3/4=0) (5/.=.), gen(gradualreform)
recode q609 (0=.) (2/3=0) (4/.=.), gen(religious)

*democracy attitudes
recode q512 (1/5=0) (6/10=1) (11/.=.)
recode q5161 (1/2=0) (3/4=1) (5/.=.)
recode q5162 (1/2=0) (3/4=1) (5/.=.)
recode q5163 (1/2=0) (3/4=1) (5/.=.)
recode q5164 (1/2=1) (3/4=0) (5/.=.)
recode q5167 (1/2=0) (3/4=1) (5/.=.)
recode q5171 (1/2=1) (3/4=0) (5/.=.)
recode q5172 (1/2=0) (3/4=1) (5/.=.)
recode q6071 (1/2=0) (3/4=1) (5/.=.)

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep country weight wave urban female lottery gradualreform religious ///
	 q512 q5161 q5162 q5163 q5164 q5167 q5171 q5172 q6071

save "wave2.dta"

append using wave3.dta
save "merged.dta"
_strip_labels *
outsheet using "IRTdemocracy23_all.csv", comma nolabel replace

erase "wave3.dta"
erase "wave2.dta"
erase "merged.dta"
